
import React from 'react';
import { useNavigate } from 'react-router-dom';
import { useAuth } from '@/contexts/AuthContext';
import { Card, CardContent, CardHeader, CardTitle, CardDescription } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { ArrowLeft, LogOut, User, Shield } from 'lucide-react';

const UserProfilePage = () => {
  const { user, logout } = useAuth();
  const navigate = useNavigate();

  const handleLogout = () => {
    logout();
    navigate('/login');
  };

  if (!user) return null;

  return (
    <div className="container mx-auto px-4 py-8 max-w-2xl">
      <div className="mb-6 flex items-center justify-between">
        <Button variant="ghost" className="text-white hover:bg-white/20" onClick={() => navigate('/menu')}>
          <ArrowLeft className="mr-2 h-4 w-4" /> Kembali ke Menu
        </Button>
        <h1 className="text-2xl font-bold text-white">Profil Pengguna</h1>
      </div>

      <Card className="bg-white/95 backdrop-blur-sm shadow-xl border-blue-200">
        <CardHeader className="flex flex-row items-center gap-4 pb-2">
          <div className="h-16 w-16 bg-blue-100 rounded-full flex items-center justify-center border-2 border-blue-500">
            <User className="h-8 w-8 text-blue-600" />
          </div>
          <div>
            <CardTitle className="text-2xl text-gray-900">{user.username}</CardTitle>
            <CardDescription className="flex items-center gap-1 text-blue-600 font-medium">
              <Shield className="h-3 w-3" /> {user.role?.toUpperCase()}
            </CardDescription>
          </div>
        </CardHeader>
        <CardContent className="space-y-6">
          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div className="space-y-1">
              <p className="text-sm text-gray-500 font-medium">Email</p>
              <p className="text-gray-900">{user.email}</p>
            </div>
            <div className="space-y-1">
              <p className="text-sm text-gray-500 font-medium">Nomor Telepon</p>
              <p className="text-gray-900">{user.nomor_telepon}</p>
            </div>
            <div className="space-y-1">
              <p className="text-sm text-gray-500 font-medium">Status Akun</p>
              <span className="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                {user.status?.toUpperCase()}
              </span>
            </div>
            <div className="space-y-1">
              <p className="text-sm text-gray-500 font-medium">Bergabung Sejak</p>
              <p className="text-gray-900">{new Date(user.created_at).toLocaleDateString('id-ID')}</p>
            </div>
          </div>

          <div className="pt-4 border-t border-gray-100">
            <h3 className="text-sm font-semibold text-gray-900 mb-3">Akses Modul</h3>
            <div className="flex flex-wrap gap-2">
              {user.access?.map((item) => (
                <span 
                  key={item.id}
                  className={`px-3 py-1 rounded-md text-sm font-medium border ${
                    item.akses 
                      ? 'bg-blue-50 text-blue-700 border-blue-200' 
                      : 'bg-gray-50 text-gray-400 border-gray-200 line-through'
                  }`}
                >
                  {item.modul.charAt(0).toUpperCase() + item.modul.slice(1)}
                </span>
              ))}
            </div>
          </div>

          <div className="pt-6">
            <Button variant="destructive" className="w-full" onClick={handleLogout}>
              <LogOut className="mr-2 h-4 w-4" /> Logout
            </Button>
          </div>
        </CardContent>
      </Card>
    </div>
  );
};

export default UserProfilePage;
