
import React from 'react';
import { AlertTriangle } from 'lucide-react';

const SupabaseWarning = () => {
  return (
    <div className="bg-amber-500 text-white px-4 py-3 shadow-lg relative z-50">
      <div className="container mx-auto flex items-start gap-3">
        <AlertTriangle className="h-6 w-6 flex-shrink-0 animate-pulse" />
        <div>
          <h3 className="font-bold text-lg">Supabase Belum Dikonfigurasi!</h3>
          <p className="text-sm mt-1 opacity-90">
            Aplikasi tidak dapat terhubung ke database. Mohon buat file <code className="bg-amber-700 px-1 rounded">.env</code> berdasarkan <code className="bg-amber-700 px-1 rounded">.env.example</code> dan isi dengan kredensial Supabase Anda.
          </p>
        </div>
      </div>
    </div>
  );
};

export default SupabaseWarning;
