
import React, { useState, useEffect } from 'react';
import { Input } from '@/components/ui/input';
import { Button } from '@/components/ui/button';
import { Search, X } from 'lucide-react';

const SearchPelanggan = ({ data, onFilter }) => {
  const [searchTerm, setSearchTerm] = useState('');

  useEffect(() => {
    if (!data) return;

    const filtered = data.filter((item) => {
      const term = searchTerm.toLowerCase();
      const nama = item.nama_pelanggan?.toLowerCase() || '';
      const telepon = item.nomor_telepon?.toLowerCase() || '';
      
      return nama.includes(term) || telepon.includes(term);
    });

    onFilter(filtered);
  }, [searchTerm, data, onFilter]);

  const handleClear = () => {
    setSearchTerm('');
  };

  return (
    <div className="relative flex items-center max-w-md w-full">
      <Search className="absolute left-3 h-4 w-4 text-gray-400" />
      <Input
        placeholder="Cari nama atau no. telepon..."
        value={searchTerm}
        onChange={(e) => setSearchTerm(e.target.value)}
        className="pl-9 pr-9 bg-white text-gray-900 border-blue-200 focus:border-blue-400"
      />
      {searchTerm && (
        <Button
          variant="ghost"
          size="sm"
          className="absolute right-1 h-7 w-7 p-0 hover:bg-transparent"
          onClick={handleClear}
        >
          <X className="h-4 w-4 text-gray-400 hover:text-gray-600" />
        </Button>
      )}
    </div>
  );
};

export default SearchPelanggan;
