
import React, { useState, useEffect } from 'react';
import { BrowserRouter, Routes, Route, Navigate } from 'react-router-dom';
import { Helmet } from 'react-helmet';
import { Toaster } from '@/components/ui/toaster';
import { AuthProvider } from '@/contexts/AuthContext';
import ProtectedRoute from '@/components/ProtectedRoute';
import LoginPage from '@/pages/LoginPage';
import RegisterPage from '@/pages/RegisterPage';
import UserProfilePage from '@/pages/UserProfilePage';
import CashierApp from '@/components/CashierApp';
import SupabaseWarning from '@/components/SupabaseWarning';
import { isSupabaseConfigured } from '@/lib/supabase';

// Utility to scroll to top on route change
const ScrollToTop = () => {
  React.useEffect(() => {
    window.scrollTo(0, 0);
  }, []);
  return null;
};

function App() {
  const [configured, setConfigured] = useState(true);

  useEffect(() => {
    // Check configuration on mount
    setConfigured(isSupabaseConfigured());
  }, []);

  return (
    <AuthProvider>
      <BrowserRouter>
        <Helmet>
          <title>BAKULAN - Aplikasi Nyatet Dagangan</title>
          <meta
            name="description"
            content="Aplikasi kasir modern untuk pencatatan transaksi penjualan, inventori, dan pelanggan."
          />
        </Helmet>
        <ScrollToTop />
        
        {/* Configuration Warning Banner */}
        {!configured && <SupabaseWarning />}

        <div className="min-h-screen bg-gradient-to-br from-slate-900 via-blue-900 to-slate-800 text-gray-900 font-sans">
          <Routes>
            {/* Public Routes */}
            <Route path="/login" element={<LoginPage />} />
            <Route path="/register" element={<RegisterPage />} />

            {/* Protected Routes */}
            <Route 
              path="/menu" 
              element={
                <ProtectedRoute>
                  <CashierApp />
                </ProtectedRoute>
              } 
            />
            <Route 
              path="/profile" 
              element={
                <ProtectedRoute>
                  <UserProfilePage />
                </ProtectedRoute>
              } 
            />

            {/* Default Redirect */}
            <Route path="/" element={<Navigate to="/menu" replace />} />
            <Route path="*" element={<Navigate to="/menu" replace />} />
          </Routes>
          <Toaster />
        </div>
      </BrowserRouter>
    </AuthProvider>
  );
}

export default App;
