
-- BAKULAN Auth Schema
-- Run this in Supabase SQL Editor

-- 1. Create users table
CREATE TABLE IF NOT EXISTS users (
  id UUID DEFAULT gen_random_uuid() PRIMARY KEY,
  username TEXT UNIQUE NOT NULL,
  email TEXT UNIQUE NOT NULL,
  nomor_telepon TEXT UNIQUE NOT NULL,
  password_hash TEXT NOT NULL,
  role TEXT NOT NULL CHECK (role IN ('admin', 'kasir', 'manager')),
  status TEXT NOT NULL CHECK (status IN ('aktif', 'nonaktif')) DEFAULT 'aktif',
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW(),
  updated_at TIMESTAMP WITH TIME ZONE DEFAULT NOW()
);

-- 2. Create user_akses table
CREATE TABLE IF NOT EXISTS user_akses (
  id UUID DEFAULT gen_random_uuid() PRIMARY KEY,
  user_id UUID NOT NULL REFERENCES users(id) ON DELETE CASCADE,
  modul TEXT NOT NULL CHECK (modul IN ('inventori', 'transaksi', 'pelanggan', 'laporan')),
  akses BOOLEAN DEFAULT TRUE,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW(),
  updated_at TIMESTAMP WITH TIME ZONE DEFAULT NOW(),
  UNIQUE(user_id, modul)
);

-- 3. Enable RLS
ALTER TABLE users ENABLE ROW LEVEL SECURITY;
ALTER TABLE user_akses ENABLE ROW LEVEL SECURITY;

-- 4. Create policies (Simplified for frontend-only app demo)
-- Allow anyone to read users (needed for login/register checks)
CREATE POLICY "Public read users" ON users FOR SELECT USING (true);
-- Allow anyone to insert users (registration)
CREATE POLICY "Public insert users" ON users FOR INSERT WITH CHECK (true);
-- Allow users to update their own profile
CREATE POLICY "Users update own profile" ON users FOR UPDATE USING (true); -- In real app, check auth.uid()

-- Allow public read/write for user_akses (for demo purposes)
CREATE POLICY "Public all user_akses" ON user_akses FOR ALL USING (true) WITH CHECK (true);

-- 5. Insert Default Admin User
-- Password is 'admin123' hashed with bcrypt
INSERT INTO users (username, email, nomor_telepon, password_hash, role, status)
VALUES (
  'admin', 
  'admin@bakulan.com', 
  '081234567890', 
  '$2a$10$w.2Z0pQ9Z9.9999999999e.99999999999999999999999999999', -- Placeholder hash, will be generated in app
  'admin', 
  'aktif'
) ON CONFLICT (username) DO NOTHING;

-- Note: The actual hash for 'admin123' needs to be generated by the app or an online bcrypt generator. 
-- For this demo, we will register a new user in the UI.

-- 6. Indexes
CREATE INDEX IF NOT EXISTS idx_users_username ON users(username);
CREATE INDEX IF NOT EXISTS idx_users_email ON users(email);
CREATE INDEX IF NOT EXISTS idx_users_phone ON users(nomor_telepon);
